% ANH NGUYEN 
% Equation:
% Measurement equation
% i_{t}= rho_{t}*i_{t-1} + (1-rho_{t})(c_{t}+a_{t}Inf_{t}+b_{t}sig_{inft}^2
% + d_{t} ugap_{t} + sig_{t} error_{t}
% rho=smoothing parameter; c= intercept; a= inflation parameter,
% b=inflation variance parameter, d= ugap parameter
% State equation
% A_{t}=[rho_{t} c_{t} a_{t} b_{t} d_{t}]
% A_{t} = A_{t-1} + W^{1/2} e_{At}
% sig_{t}=sig_{t-1} + sigsig*u_{sigt} (Because variance
% can go to infinity);
% Parameters: 5 STD W; alphasig, rhosigm, sigsig

% Because rho lies in [0,1] and sig must be positive
% rho= exp(rho_new)/(exp(rho_new)+1);
% sig=exp(sig_new);


function L=rule_nonlinear_lk_RW(param)

global seed;
% inf= Inflation
% infv= Inf Variance
% ug=Unemployment
% T= Number of samples
% seed = iteration

data=xlsread('Data_Quaterly_Prepared');
r=data(:,2);
inf=data(:,3);
ug=data(:,5); 
T=size(r,1);
ns= 6;

load infvar;
infv=mean_f;


sig_sig=exp(param(1));
sig_rho=exp(param(2));
sig_c=exp(param(3));
sig_a=exp(param(4));
sig_b=exp(param(5));
sig_d=exp(param(6)); 


% Save
logl=zeros(T-1,1);
Neff=zeros(T-1,1);

% FOR LAW OF MOTION
load initialgridsearch_base; 
% initial states are chosen based on grid search, starting around the simple estimates for the 1960s periods
X0=[startpoint(1); startpoint(2); startpoint(3); startpoint(4); startpoint(5); startpoint(6)];

MVN=[sig_sig 0 0 0 0 0;
    0 sig_rho 0 0 0 0;
    0    0  sig_c 0 0 0;
    0  0 0 sig_a 0 0;
    0  0  0  0 sig_b 0;
    0  0  0   0   0 sig_d];
% PARTICLE FILTERS
N = 10000; 

% Set state
seed=seed+1;
randn('state', 039+seed)  %
rand('state',127+seed)
randnumber=rand(T-1,1);
% Generate random samples at T=2
U=randn(ns,N);

% Update states
repmatX0=repmat(X0,1,N);

X= repmatX0 + MVN*U(1:(ns),:);


% IMPORTANCE WEIGHT
RHO=exp(X(2,:))./(exp(X(2,:))+1);

Y=RHO*r(1)+(1-RHO).*(X(3,:)+X(4,:)*inf(2)+X(5,:)*infv(2)+X(6,:)*ug(2));
Yt=repmat(r(2),1,N);

weight = normpdf(Yt,Y,exp(X(1,:)));

% Likelihood
logl(1)=log(mean(weight));

%Normalizing
weight=weight/sum(weight);

% RESAMPLING
ind=resamplesys(weight,N,randnumber(1));

for t=3:T;
    
X1=X(:,ind);

% Generate random samples at T=2
U=randn(ns,N);

% Update states

X= X1 + MVN*U(1:(ns),:);

% IMPORTANCE WEIGHT
% Mean: Note that Inflation and UG are of time 2
RHO=exp(X(2,:))./(exp(X(2,:))+1);
Y=RHO*r(t-1)+(1-RHO).*(X(3,:)+X(4,:)*inf(t)+X(5,:)*infv(t)+X(6,:)*ug(t));
Yt=repmat(r(t),1,N);

weight = normpdf(Yt,Y,exp(X(1,:)));

% Likelihood
logl(t-1)= log(mean(weight));

%Normalizing
weight=weight/sum(weight);

% RESAMPLING
ind=resamplesys(weight,N,randnumber(t-1));

end

L=-sum(logl(11:T-1));  % using the first 10 as trial sample to find a reasonable state

